IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PARAM_COMPRAS_GRUPO_CURVA_VALORES]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PARAM_COMPRAS_GRUPO_CURVA_VALORES]
GO  
--SELECT * FROM UFD_EST_PARAM_COMPRAS_GRUPO_CURVA_VALORES (1,22,353051)
CREATE FUNCTION [dbo].[UFD_EST_PARAM_COMPRAS_GRUPO_CURVA_VALORES]  (@CD_EMP  INT,      
																		@CD_CTR INT,  
																		@CD_PROD INT)  
RETURNS @RS_TAB_COMIS TABLE ( CD_EMP INT,
									  CD_CTR INT,
									  CD_PROD INT,
									  CD_GRUPO_CURVA INT,
									  CD_SIGLA INT,
									  DS_SIGLA VARCHAR(2),
									  ORDEM_SIGLA INT,
									  ESEG INT,
									  EMAX INT,
									  P1 MONEY,
									  P2 MONEY,
									  P1_SAZ MONEY,
									  P2_SAZ MONEY,
									  FREVISAOMEDIAF INT,
									  PERC_PARETO_ACUMULADO MONEY,
									  TP_NIVEL	INT,
									  FLAG_NAO_REVISAR_PARETO_AUTO INT,
									  VLR_PARAMETRO_ATUAL MONEY,
									  FREVISAOCURVA INT)  
WITH ENCRYPTION AS                
BEGIN                
          
DECLARE @RS_DADOS_TBL_PARAM AS TABLE (CD_EMP INT,
									  CD_CTR INT,
									  CD_PROD INT,
									  CD_GRUPO_CURVA INT,
									  CD_SIGLA INT,
									  ESEG INT,
									  EMAX INT,
									  P1 MONEY,
									  P2 MONEY,
									  P1_SAZ MONEY,
									  P2_SAZ MONEY,
									  FREVISAOMEDIAF INT,
									  PERC_PARETO_ACUMULADO MONEY,
									  TP_NIVEL	INT,
									  FLAG_NAO_REVISAR_PARETO_AUTO INT,
									  FREVISAOCURVA INT)  

 -------------------------------------------------------------------------------------------------------------------------------      
 --DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO      
 -------------------------------------------------------------------------------------------------------------------------------      
 DECLARE @EST_PROD_ARV_MERC TABLE (  CD_EMP     INT,      
          CD_PROD   INT,      
          CD_ARV_MERC_CATEG INT,      
          CD_ARV_MERC_SEG INT,      
          CD_ARV_MERC_PAPEL INT,      
          CD_ARV_MERC_MIX INT,      
          CD_ARV_MERC_CONSUMO INT,      
          CD_ARV_MERC_LINHA INT,      
          CD_ARV_MERC_MTZ_BCG INT,      
          CD_MC   INT,      
          CD_ARV_MERC_FAMILIA INT,              
          CD_APRES   INT,          
          CD_ARV_MERC_EQUI INT,      
          CD_GRP_EXPO  INT,      
          CD_FABRIC   INT)      
            
 -------------------------------------------------------------------------------------------------------------------------------      
 --BUSCANDO ARVORE MERC. DO PRODUTO      
 -------------------------------------------------------------------------------------------------------------------------------       
	INSERT INTO @EST_PROD_ARV_MERC      
	SELECT       
		ARV.CD_EMP     ,      
		ARV.CD_PROD     ,      
		ARV.CD_ARV_MERC_CATEG  ,      
		ARV.CD_ARV_MERC_SEG   ,      
		ARV.CD_ARV_MERC_PAPEL  ,      
		ARV.CD_ARV_MERC_MIX   ,      
		ARV.CD_ARV_MERC_CONSUMO  ,      
		ARV.CD_ARV_MERC_LINHA  ,      
		ARV.CD_ARV_MERC_MTZ_BCG  ,      
		ARV.CD_MC     ,      
		ARV.CD_ARV_MERC_FAMILIA  ,              
		ARV.CD_APRES    ,          
		ARV.CD_ARV_MERC_EQUI  ,      
		ARV.CD_GRP_EXPO    ,      
		P.CD_FABRIC       
	FROM 
		EST_PROD_EST_ARV_MERCADOLOGICA ARV 
		INNER JOIN EST_PROD P ON      
		ARV.CD_EMP  = P.CD_EMP      
		AND ARV.CD_PROD = P.CD_PROD      
	WHERE   
		P.CD_EMP = @CD_EMP       
		AND P.CD_PROD = @CD_PROD;
           
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de GRUPO CURVA VALORES no NVEL 1 - PRODUTOS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT
		 P.CD_EMP,
		 P.CD_CTR,
		 ARV.CD_PROD,
		 B.CD_GRUPO_CURVA,
		 B.CD_SIGLA,
		 B.ESEG,
		 B.EMAX,
		 B.P1,
		 B.P2,
		 B.P1_SAZ,
		 B.P2_SAZ,
		 B.FREVISAOMEDIAF,
		 B.PERC_PARETO_ACUMULADO,
		 1 AS TIPO_NIVEL,
		 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
		 B.FREVISAOCURVA
	FROM
		 EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_PROD P ON
		 B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		P.CD_EMP = ARV.CD_EMP AND      
		P.CD_PROD = ARV.CD_PROD             
	WHERE
		P.CD_EMP=@CD_EMP
		AND P.CD_CTR=@CD_CTR
		AND NOT EXISTS (SELECT 
						T.CD_GRUPO_CURVA 
					 FROM 
						@RS_DADOS_TBL_PARAM T 
					 WHERE 
						T.CD_CTR = P.CD_CTR)   		
	  ORDER BY 
			B.DT_CAD DESC
		
      
 -----------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de GRUPO CURVA VALORES no NVEL 2 - FAMLIAS      
 -----------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT
		 P.CD_EMP,
		 P.CD_CTR,
		 ARV.CD_PROD,
		 B.CD_GRUPO_CURVA,
		 B.CD_SIGLA,
		 B.ESEG,
		 B.EMAX,
		 B.P1,
		 B.P2,
		 B.P1_SAZ,
		 B.P2_SAZ,
		 B.FREVISAOMEDIAF,
		 B.PERC_PARETO_ACUMULADO,
		 2 AS TIPO_NIVEL,
		 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
		 B.FREVISAOCURVA
	FROM
		 EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_ARV_MERC_FAMILIA P ON
		 B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		P.CD_EMP = ARV.CD_EMP AND      
		P.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA             
	WHERE
		P.CD_EMP=@CD_EMP
		AND P.CD_CTR=@CD_CTR
		AND NOT EXISTS (SELECT 
						T.CD_GRUPO_CURVA 
					 FROM 
						@RS_DADOS_TBL_PARAM T 
					 WHERE 
						T.CD_CTR = P.CD_CTR)   		
	  ORDER BY 
			B.DT_CAD DESC  
          
 -----------------------------------------------------------------------------------------------------------------------------          
 --Consultando as tbls de GRUPO CURVA VALORES no NVEL 3 - MARCAS      
 -----------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT
		 P.CD_EMP,
		 P.CD_CTR,
		 ARV.CD_PROD,
		 B.CD_GRUPO_CURVA,
		 B.CD_SIGLA,
		 B.ESEG,
		 B.EMAX,
		 B.P1,
		 B.P2,
		 B.P1_SAZ,
		 B.P2_SAZ,
		 B.FREVISAOMEDIAF,
		 B.PERC_PARETO_ACUMULADO,
		 3 AS TIPO_NIVEL,
		 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
		 B.FREVISAOCURVA
	FROM
		 EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_MC P ON
		 B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		P.CD_EMP = ARV.CD_EMP AND      
		P.CD_MC = ARV.CD_MC             
	WHERE
		P.CD_EMP=@CD_EMP
		AND P.CD_CTR=@CD_CTR
		AND NOT EXISTS (SELECT 
						T.CD_GRUPO_CURVA 
					 FROM 
						@RS_DADOS_TBL_PARAM T 
					 WHERE 
						T.CD_CTR = P.CD_CTR)   		
	  ORDER BY 
			B.DT_CAD DESC  
      
 -----------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de GRUPO CURVA VALORES no NVEL 4 - FABRICANTES      
 -----------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT
		 P.CD_EMP,
		 P.CD_CTR,
		 ARV.CD_PROD,
		 B.CD_GRUPO_CURVA,
		 B.CD_SIGLA,
		 B.ESEG,
		 B.EMAX,
		 B.P1,
		 B.P2,
		 B.P1_SAZ,
		 B.P2_SAZ,
		 B.FREVISAOMEDIAF,
		 B.PERC_PARETO_ACUMULADO,
		 4 AS TIPO_NIVEL,
		 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
		 B.FREVISAOCURVA
	FROM
		 EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_PROD_FABRIC P ON
		 B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON         
		P.CD_FABRIC = ARV.CD_FABRIC             
	WHERE
		P.CD_EMP=@CD_EMP
		AND P.CD_CTR=@CD_CTR
		AND NOT EXISTS (SELECT 
						T.CD_GRUPO_CURVA 
					 FROM 
						@RS_DADOS_TBL_PARAM T 
					 WHERE 
						T.CD_CTR = P.CD_CTR)   		
	  ORDER BY 
			B.DT_CAD DESC  

-----------------------------------------------------------------------------------------------------------------------------      
--Consultando as tbls de GRUPO CURVA VALORES no NVEL 5 - CATEGORIAS      
 -----------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT
		 P.CD_EMP,
		 P.CD_CTR,
		 ARV.CD_PROD,
		 B.CD_GRUPO_CURVA,
		 B.CD_SIGLA,
		 B.ESEG,
		 B.EMAX,
		 B.P1,
		 B.P2,
		 B.P1_SAZ,
		 B.P2_SAZ,
		 B.FREVISAOMEDIAF,
		 B.PERC_PARETO_ACUMULADO,
		 5 AS TIPO_NIVEL,
		 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
		 B.FREVISAOCURVA
	FROM
		 EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_ARV_MERC_CATEGORIA P ON
		 B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		P.CD_EMP = ARV.CD_EMP AND      
		P.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG             
	WHERE
		P.CD_EMP=@CD_EMP
		AND P.CD_CTR=@CD_CTR
		AND NOT EXISTS (SELECT 
						T.CD_GRUPO_CURVA 
					 FROM 
						@RS_DADOS_TBL_PARAM T 
					 WHERE 
						T.CD_CTR = P.CD_CTR)   		
	  ORDER BY 
			B.DT_CAD DESC  
		
 --------------------------------------------------------------------------------------------------------------------------      
--Consultando as tbls de GRUPO CURVA VALORES no NVEL 6 - LINHAS      
 ---------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT
		 P.CD_EMP,
		 P.CD_CTR,
		 ARV.CD_PROD,
		 B.CD_GRUPO_CURVA,
		 B.CD_SIGLA,
		 B.ESEG,
		 B.EMAX,
		 B.P1,
		 B.P2,
		 B.P1_SAZ,
		 B.P2_SAZ,
		 B.FREVISAOMEDIAF,
		 B.PERC_PARETO_ACUMULADO,
		 6 AS TIPO_NIVEL,
		 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
		 B.FREVISAOCURVA
	FROM
		 EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_ARV_MERC_LINHA P ON
		 B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		P.CD_EMP = ARV.CD_EMP AND      
		P.CD_ARV_MERC_LINHA = ARV.CD_ARV_MERC_LINHA             
	WHERE
		P.CD_EMP=@CD_EMP
		AND P.CD_CTR=@CD_CTR
		AND NOT EXISTS (SELECT 
						T.CD_GRUPO_CURVA 
					 FROM 
						@RS_DADOS_TBL_PARAM T 
					 WHERE 
						T.CD_CTR = P.CD_CTR)   		
	  ORDER BY 
			B.DT_CAD DESC  

	INSERT INTO @RS_TAB_COMIS   
	SELECT
			@CD_EMP,
			@CD_CTR, 
			@CD_PROD,
			A.CD_GRUPO_CURVA,
			A.CD_SIGLA,
			CASE WHEN A.CD_SIGLA=5 THEN
				'AA'
			WHEN A.CD_SIGLA=1 THEN
				'A'
			WHEN A.CD_SIGLA=2 THEN
				'B'
			WHEN A.CD_SIGLA=3 THEN
				'C'
			WHEN A.CD_SIGLA=4 THEN
				'D'
			END DS_SIGLA,
			CASE WHEN A.CD_SIGLA=5 THEN
				0
			WHEN A.CD_SIGLA=1 THEN
				1
			WHEN A.CD_SIGLA=2 THEN
				2
			WHEN A.CD_SIGLA=3 THEN
				3
			WHEN A.CD_SIGLA=4 THEN
				4
			END ORDEM_SIGLA,
			A.ESEG,
			A.EMAX,
			A.P1,
			A.P2,
			A.P1_SAZ,
			A.P2_SAZ,
			A.FREVISAOMEDIAF,
			A.PERC_PARETO_ACUMULADO,
			A.TP_NIVEL,
			A.FLAG_NAO_REVISAR_PARETO_AUTO,
			ISNULL(EST_PARAM_COMPRAS_GRUPO_CURVA_USO.VLR_PARAMETRO,0),
			FREVISAOCURVA
	FROM 
		@RS_DADOS_TBL_PARAM A  LEFT OUTER JOIN EST_PARAM_COMPRAS_GRUPO_CURVA_USO ON
		A.CD_GRUPO_CURVA = EST_PARAM_COMPRAS_GRUPO_CURVA_USO.CD_GRUPO_CURVA AND
		A.CD_CTR =  EST_PARAM_COMPRAS_GRUPO_CURVA_USO.CD_CTR_COMPRAS_GRUPO AND 
		A.CD_SIGLA = EST_PARAM_COMPRAS_GRUPO_CURVA_USO.CD_SIGLA AND
		A.TP_NIVEL = EST_PARAM_COMPRAS_GRUPO_CURVA_USO.TP_NIVEL
	ORDER BY 
		TP_NIVEL ASC
RETURN  
END